/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.UserSelectable;

public class ExternalStoreActivity
extends StoreActivity
implements UserSelectable {
    private Type type = Type.STANDARD;
    private String description = "";
    private boolean selected = false;
    private double qtyOffset = 0.0;
    private long timeOffset = 0L;

    public ExternalStoreActivity(long time, Material material, double qty) {
        super(StoreType.EXTERNAL, time, material, qty);
    }

    public ExternalStoreActivity(long time, Material material, double qty, String description) {
        this(time, material, qty);
        this.description = description;
    }

    public ExternalStoreActivity(long time, Material material, double qty, long timeOffset, double qtyOffset, Type type) {
        super(StoreType.EXTERNAL, time, material, qty);
        this.timeOffset = timeOffset;
        this.qtyOffset = qtyOffset;
        this.type = type;
    }

    public ExternalStoreActivity(long time, Material material, double qty, long timeOffset, double qtyOffset, Type type, String description) {
        this(time, material, qty, timeOffset, qtyOffset, type);
        this.description = description;
    }

    public ExternalStoreActivity(ExternalStoreActivity other) {
        super(other);
        this.qtyOffset = other.qtyOffset;
        this.timeOffset = other.timeOffset;
        this.description = other.description;
    }

    @Override
    public Activity duplicate() {
        return new ExternalStoreActivity(this);
    }

    @Override
    public boolean isUserSelected() {
        return this.selected;
    }

    @Override
    public void setUserSelected(boolean selected) {
        this.selected = selected;
    }

    public double getQtyOffset() {
        return this.qtyOffset;
    }

    public void setQtyOffset(double qtyOffset) {
        this.qtyOffset = qtyOffset;
        this.updateChanged();
    }

    private void updateChanged() {
        if (this.type != Type.VIRTUAL) {
            this.type = Type.CHANGED;
            if (this.timeOffset == 0L && Double.compare(this.qtyOffset, 0.0) == 0) {
                this.type = Type.STANDARD;
            }
        }
    }

    public void changeQtyOffsetBy(double qtyOffset) {
        this.qtyOffset += qtyOffset;
        this.updateChanged();
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long timeOffset) {
        this.timeOffset = timeOffset;
        this.updateChanged();
    }

    public void changeTimeOffsetBy(long timeOffset) {
        this.timeOffset += timeOffset;
        this.updateChanged();
    }

    @Override
    public double getQty() {
        return super.getQty() + this.qtyOffset;
    }

    @Override
    public void setQty(double qty) {
        super.setQty(qty);
        this.qtyOffset = 0.0;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.timeOffset = 0L;
    }

    public void setTimeWithOffset(long time) {
        this.timeOffset = time - super.getStart();
        this.updateChanged();
    }

    public void setQtyWithOffset(double qty) {
        this.qtyOffset = qty - super.getQty();
        this.updateChanged();
    }

    @Override
    public long getStart() {
        return super.getStart() + this.timeOffset;
    }

    @Override
    public long getEnd() {
        return super.getEnd() + this.timeOffset;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Object getOriginator() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static enum Type {
        STANDARD,
        VIRTUAL,
        CHANGED;


        public String toString() {
            switch (this) {
                case STANDARD: {
                    return Localizer.getString("external_store_activity.type.standard");
                }
                case VIRTUAL: {
                    return Localizer.getString("external_store_activity.type.virtual");
                }
                case CHANGED: {
                    return Localizer.getString("external_store_activity.type.changed");
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

